; MOUSE213.ASM 07JAN04 - JOHN BECKER - EPE PIC TO MOUSE DEMO

#DEFINE BANK0   BCF $03,5
#DEFINE BANK1   BSF $03,5

        List P = PIC16F628, R=DEC; 
        __CONFIG   h'3F31'

        include P16F628.inc

        CBLOCK  ; start of automatic EQUates allocation, from $20 onwards

BYTEIN 
BYTEOUT
BYTE1 
BYTE2 
BYTE3 
DIGIT9
DIGIT10
SWITCH
LOOP
CLKCNT
STORE1
RSLINE
LOOPA
STORE
PARITY
PARITYBIT
STOPBIT
STARTBIT
FLASH

        ENDC    ; end of equates allocation

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5
                goto START

TABLCD:         addwf PCL,F             ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end inititalisation table
                 
MESSAG:         addwf PCL,F
                retlw 'M'
                retlw 'O'
                retlw 'U'
                retlw 'S'
                retlw 'E'
                retlw ' '
                retlw 'D'
                retlw 'E'
                retlw 'M'
                retlw 'O'
                retlw ' '
                retlw ' '
                retlw ' '
                retlw ' '
                retlw ' '
                retlw ' '

BUTTON:         movf SWITCH,W
                andlw %00000111
                addwf PCL,F
                goto NIL
                goto LEFTONE
                goto RIGHTONE
                goto BOTH
                goto MIDDLE
                goto NIL
                goto NIL
                goto NIL


START:          movlw 255
                movwf PORTA
                clrf PORTB
                movlw $07         ; activate PORTA for PC16F628 as digital
                movwf CMCON

                BANK1
                clrf TRISB        ; PORTB as output
                movlw 255
                movwf TRISA       ; PORTA as input
                movlw %10000110   ; set timer 1:64, PORTB pullups off
                movwf OPTION_REG
                BANK0

SETUP:          call PAUSIT       ; 1st 1/5th sec delay
LCDSET:         clrf LOOP         ; clear LCD set-up loop
                clrf RSLINE       ; clear RS line for instruction send
LCDST2:         movf LOOP,W       ; get table address
                call TABLCD       ; get set-up instruction
                call LCDOUT       ; perform it
                incf LOOP,F       ; inc loop
                btfss LOOP,3      ; has last LCD set-up instruction now been done?
                goto LCDST2       ; no
                call PAUSIT       ; 1/5th sec delay
                 
LCDMSG:         clrf LOOP         ; clear loop
                bsf RSLINE,4      ; set RS for data send
LCDMS2:         movf LOOP,W       ; get table address
                call MESSAG       ; get message letter
                call LCDOUT       ; show it
                incf LOOP,F       ; inc loop
                btfss LOOP,4      ; has last LCD letter been sent?
                goto LCDMS2       ; no, repeat for next
                call PAUSIT

; DATA = RA0   CLK = RA1

      movlw $FF        ; RESET command (automatically sets for STREAM mode)
      movwf BYTEOUT
      call SENDCOMMAND

      call RECEIVEDATA ; read 1st byte (but ignore)

      movlw $F5        ; DATA REPORTING ENABLE command
      movwf BYTEOUT
      call SENDCOMMAND

      movlw $F3        ; SAMPLING RATE CHANGE command
      movwf BYTEOUT
      call SENDCOMMAND

      movlw $0A        ; SAMPLING RATE VALUE
      movwf BYTEOUT
      call SENDCOMMAND

      movlw $E8        ; set RESOLUTION command
      movwf BYTEOUT
      call SENDCOMMAND

      movlw $03        ; RESOLUTION VALUE
      movwf BYTEOUT
      call SENDCOMMAND

      movlw $F0        ; set REMOTE command (constant reading) ****
      movwf BYTEOUT    ; omit this command if
      call SENDCOMMAND ; STREAM mode required

      movlw $F4        ; ENABLE command
      movwf BYTEOUT
      call SENDCOMMAND

MAIN: call LCD1

      movlw $EB            ; READ DATA command ***
      movwf BYTEOUT        ; omit this command if
      call SENDCOMMAND     ; STREAM mode required

      call RECEIVEDATA     ; read first byte, but ignore *** omit this command if STREAM mode required

      call RECEIVEDATA     ; buttons etc
      movf BYTEIN,W
      movwf BYTE1
      movwf SWITCH         ; temp store

      call RECEIVEDATA     ; X axis
      movf BYTEIN,W
      movwf BYTE2

      call RECEIVEDATA     ; Y axis
      movf BYTEIN,W
      movwf BYTE3

      movlw 8              ; show binary of buttons etc
      movwf LOOP
BINARY: rlf BYTE1,F
      movf STATUS,W
      andlw 1
      iorlw 48
      call LCDOUT
      decfsz LOOP,F
      goto BINARY
      movlw ' '
      call LCDOUT

      call BUTTON          ; show mouse button status

      call LCD21
      movlw 'X'
      call LCDOUT
      movlw '+'
      btfsc SWITCH,4      ; X movement direction sign
      movlw '-'
      call LCDOUT
      movf BYTE2,W        ; X axis
      call BIN2HEX
      movlw ' '
      btfsc SWITCH,6
      movlw '#'           ; X overflow flag  " " = ok, "#" = overflow
      call LCDOUT
      movlw ' '
      call LCDOUT

      movlw 'Y'
      call LCDOUT
      movlw '+'
      btfsc SWITCH,5      ; Y movement direction sign
      movlw '-'
      call LCDOUT
      movf BYTE3,W        ; Y axis
      call BIN2HEX
      movlw ' '
      btfsc SWITCH,7      ; Y overflow flag  " " = ok, "#" = overflow
      movlw '#'
      call LCDOUT         ; NB SWITCH bit 3 is "dont care" and may be 1 or 0

      call LCD16          ; show asterisc alternate data reads (to prove activity!)
      incf FLASH,F
      movlw ' '
      btfss FLASH,1
      movlw '*'
      call LCDOUT

      goto MAIN

; *********  SEND COMMAND TO MOUSE *******

SENDCOMMAND:
      clrf PARITY
      bcf PORTA,1        ; set clk low for at least 100us (1)
      BANK1
      bcf TRISA,1        ; set clk as output
      BANK0

      call WAIT50        ; wait 200ms
      call WAIT50

      bcf PORTA,0        ; set data low (START bit)  (2)
      BANK1
      bcf TRISA,0        ; set data as output
      BANK0

      BANK1
      bsf TRISA,1        ; set clk as input (3)
      BANK0

      call WAITCLKDOWN   ; wait clk to go low (4)

SENDLOOP: movlw 8        ; send 8 bits of data Bit0 to Bit7
       movwf LOOP

SEND2: movf BYTEOUT,W    : only bit 0 has any effect
       movwf PORTA       ; send data bit (5)
       BANK1
       bcf TRISA,0       ; set data as output
       BANK0

       movf BYTEOUT,W    ; get parity val (bit 0)
       andlw 1
       addwf PARITY,F    ; add it to PARITY counter

       call WAITCLKUP    ; (6)
       call WAITCLKDOWN  ; (7)
       rrf BYTEOUT,F
       decfsz LOOP,F
       goto SEND2        ; (8)

       comf PARITY,W     ; odd parity
       movwf PORTA       ; send parity bit (5)
       call WAITCLKUP    ; (6)
       call WAITCLKDOWN  ; (7)

       BANK1
       bsf PORTA,0       ; set data as input (9)
       BANK0

       call WAITDATADOWN ; (10)
       call WAITCLKDOWN  ; (11)

       call WAITCLKUP    ; (12)
       call WAITDATAUP

       return

; ********** RECEIVE DATA FROM MOUSE *******

RECEIVEDATA:
       clrf BYTEIN
       clrf PARITY
       BANK1
       movlw %11111111   ; set Data & Clk as inputs (biased high by R1 & R2)
       movwf TRISA
       BANK0

WAITSTARTBIT:
       comf PORTA,W      ; wait till RA0 & RA1 are high
       andlw %00000011
       btfss STATUS,Z
       goto WAITSTARTBIT

       call WAITCLKDOWN  ; get Start bit
       movf PORTA,W
       andlw %00000001
       movwf STARTBIT
       call WAITCLKUP
       btfsc STARTBIT,0  ; is data = 0 (start bit)?
       goto WAITSTARTBIT ; no

       movlw 8           ; yes
       movwf LOOP
       clrf PARITY

RECEIVELOOP:
       call WAITCLKDOWN
       rrf PORTA,W       ; rotate data bit into carry and into BYTEIN
       rrf BYTEIN,F

       btfsc PORTA,0     ; add to parity count if data high
       incf PARITY,F

       call WAITCLKUP
       decfsz LOOP,F
       goto RECEIVELOOP

       call WAITCLKDOWN    ; get parity bit
       movf PORTA,W
       andlw %00000001
       movwf PARITYBIT     ; parity bit not used, but must still be read
       call WAITCLKUP

       call WAITCLKDOWN    ; get stop bit
       movf PORTA,W
       andlw %00000001
       movwf STOPBIT       ; stop bit not used, but must still be read

       return

; *********

WAITCLKUP: btfss PORTA,1   ; wait till clock goes high
      goto WAITCLKUP
      return

WAITCLKDOWN: btfsc PORTA,1 ; wait till clock goes low
      goto WAITCLKDOWN
      return

WAITDATAUP: btfss PORTA,0  ; wait till data goes high
      goto WAITDATAUP
      return

WAITDATADOWN: btfsc PORTA,0 ; wait till data goes low
      goto WAITDATADOWN
      return

;*******

WAIT50:  movlw 50           ; delay for 50x2=100 us (at 4MHz PIC clock)
         movwf LOOP
WAIT50a: decfsz LOOP,F
         goto WAIT50A
         return

; *************** CONVERT BYTE TO HEX & SHOW IT ******

BIN2HEX: movwf STORE
        swapf STORE,W   ;get most significant nibble
        andlw 15
        movwf DIGIT9
        addlw 6
        btfss STATUS,DC
        goto BIN2
        movf DIGIT9,W
        addlw 55        ;set as alpha
        goto BIN3
BIN2:   movf DIGIT9,W
        iorlw 48        ;set as numeral
BIN3:   movwf DIGIT9
        movf STORE,W    ;get least significant nibble
        andlw 15
        movwf DIGIT10
        addlw 6
        btfss STATUS,DC
        goto BIN4
        movf DIGIT10,W
        addlw 55        ;set as alpha
        goto BIN5
BIN4:   movf DIGIT10,W
        iorlw 48        ;set as numeral
BIN5:   movwf DIGIT10

SHOWHEX: movf DIGIT9,W
      call LCDOUT
      movf DIGIT10,W
      call LCDOUT
      return

;********** LCD CONTROL SECTION *********

LCD1:   movlw %10000000 ; set screen line start position
        goto LCDLIN

LCD16:  movlw %10001111 ; set screen line start position
        goto LCDLIN

LCD21:  movlw %11000000 ; set screen line start position
        goto LCDLIN

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 60        ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        nop
        bsf PORTB,5     ; set E high
        nop
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 5         ; 1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:                  ;
        btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes


; ********** MOUSE BUTTON INTERPRETATION *******

NIL:            movlw 'N'
                call LCDOUT
                movlw 'I'
                call LCDOUT
                movlw 'L'
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                return

LEFTONE:        movlw 'L'
                call LCDOUT
                movlw 'E'
                call LCDOUT
                movlw 'F'
                call LCDOUT
                movlw 'T'
                call LCDOUT
                movlw ' '
                call LCDOUT
                return

RIGHTONE:       movlw 'R'
                call LCDOUT
                movlw 'I'
                call LCDOUT
                movlw 'G'
                call LCDOUT
                movlw 'H'
                call LCDOUT
                movlw 'T'
                call LCDOUT
                return

BOTH:           movlw 'B'
                call LCDOUT
                movlw 'O'
                call LCDOUT
                movlw 'T'
                call LCDOUT
                movlw 'H'
                call LCDOUT
                movlw ' '
                call LCDOUT
                return

MIDDLE:         movlw 'M'
                call LCDOUT
                movlw 'I'
                call LCDOUT
                movlw 'D'
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                return

        END
